function PolyAssoLag=PolyAssoLaguerre(n,l,var)

%% Polynme associ de Laguerre
% Fonction qui calcule le polynme associ de Laguerre L(p,q) 
% avec p=n+l et q=2l+1. 
%
% Entres : n, l et variable var
% Sorties : PolyAssoLag : polynme associ de Laguerre
%
% Olivier Pujol : septembre 2013

k=0:1:n-l-1;
C=gamma(n+l+1)^2./(gamma(k+2*l+2).*gamma(n-l-k).*gamma(k+1));

PolyAssoLag=zeros(size(var));
for i=1:length(k)
    PolyAssoLag=PolyAssoLag ...
        + (-1)^(k(i)+2*l+1).*C(i)*var.^(k(i));
end

return;